# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdapiobject import SDAPIObject
from .sdbasetypes import float2
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDGraphObject(SDAPIObject):
    """
    Class managing an object in a graph that is neither a node nor a connection (e.g. comment, frame, ...)
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDGraphObject
        """
        super(SDGraphObject, self).__init__(APIContext, handle, *args, **kwargs)

    def getPosition(self) -> float2:
        """
        Get the SDGraphObject position

        """
        outPosition = float2()
        _res = self.mAPIContext.SDGraphObject_getPosition(self.mHandle, ctypes.byref(outPosition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPosition

    def setPosition(self, position : float2) -> None:
        """
        Set the SDGraphObject position

        :param position: The new position in the graph
        """
        _res = self.mAPIContext.SDGraphObject_setPosition(self.mHandle, ctypes.byref(position))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getDescription(self) -> str:
        """
        Get the SDGraphObject description

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDGraphObject_getDescription(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

    def setDescription(self, value : str) -> None:
        """
        Set the SDGraphObject description

        :param value: The new description
        """
        _res = self.mAPIContext.SDGraphObject_setDescription(self.mHandle, ctypes.create_string_buffer(value.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

